///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _DORECEIVE_CPP
#define _DORECEIVE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CSockSrvr::DoRecv(int iClient)
{
    #ifdef _DEBUG_SOCK_SERVER
    printf("DEBUG: [In Proc]> CSockSrvr::DoRecv.");
    #endif

	//The data received exceeds our local receive buffer size.
	if(icRecvBufSz[iClient] > icHardRecvBufSz)
	{
		return false;
	}

    int iResult = 0;
    int iRecvSize = icHardRecvBufSz;

	if((iResult = recv(sckcSocket[iClient], scRecvBuffer, iRecvSize, MSG_PEEK)) == SOCKET_ERROR)
	{
		bcDisconnect[iClient] = true;
		return false;
	}
	else if(iResult == 0) // Gracefull disconnect
	{
		bcDisconnect[iClient] = true;
		return false;
	}
	else iRecvSize = iResult;

	//Does the data received plus the data already in the buffer
	//	exceed the client receive buffer size?
	if((icRecvBufSz[iClient] + iResult) > icHardRecvBufSz)
	{
		//Get the ammount of data that is required to complete the current packet.
		int iPartialSize = GetPartialPacketDifference(iClient);

		//Does the client receive buffer contains a partial packet?
		if(iPartialSize > -1)
		{
			//Can we fit the remainder of the partial packet in the client receive buffer?
			if(iPartialSize <= (icHardRecvBufSz - icRecvBufSz[iClient]))
			{
				iRecvSize = iPartialSize;
			}
		}
		else return false;
	}

	if((iResult = recv(sckcSocket[iClient], scRecvBuffer, iRecvSize, 0)) == SOCKET_ERROR)
	{
		bcDisconnect[iClient] = true;
		return false;
	}
	else if(iResult == 0) // Gracefull disconnect
	{
		bcDisconnect[iClient] = true;
		return false;
	}

	if(!Events.OnRecv(this, iClient, scRecvBuffer, iResult))
	{
		return true; //All is well.
	}

	icRecvOffset[iClient] = 0;

    if(bcConnected[iClient] && !bcDisconnect[iClient])
    {
		if((icRecvBufSz[iClient] + iResult) >= icMaxRecvBufSz[iClient])
		{
			if(!ResizeRecvBuffer(iClient, (icRecvBufSz[iClient] + iResult) + 1))
			{
				return false;
			}
		}

		//The client receive buffer IS empty, so just COPY the received data to it.
		if(icRecvBufSz[iClient] == 0)
		{
			memcpy(scRecvBuf[iClient], scRecvBuffer, iResult);
	        icRecvBufSz[iClient] = iResult;
		}
		else{
			//The client receive buffer NOT is empty, APPEND the received data to it.
			int iRPos = 0;
			int iWPos = icRecvBufSz[iClient];

			while(iRPos < iResult)
			{
				scRecvBuf[iClient][iWPos] = scRecvBuffer[iRPos];
				iRPos++;
				iWPos++;
			}
			icRecvBufSz[iClient] = (icRecvBufSz[iClient] + iResult);
		}
	}
    else return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
